Scriptname USSHolotapeQuestScript extends Quest Conditional

Message Property _USSMessageUnlimited Auto Const Mandatory

GlobalVariable Property _USSAttackReducerExponent Auto Mandatory
GlobalVariable Property _USSEnableAttackReducer Auto Mandatory

GlobalVariable Property _USSCapFood Auto Mandatory
GlobalVariable Property _USSCapWater Auto Mandatory
GlobalVariable Property _USSCapScrap Auto Mandatory

GlobalVariable Property _USSFoodChanceNone Auto Mandatory
GlobalVariable Property _USSWaterChanceNone Auto Mandatory
GlobalVariable Property _USSScrapChanceNone Auto Mandatory

GlobalVariable Property _USSEnableFood Auto Mandatory
GlobalVariable Property _USSEnableWater Auto Mandatory
GlobalVariable Property _USSEnableScrap Auto Mandatory
GlobalVariable Property _USSEnableFertilizer Auto Mandatory
GlobalVariable Property _USSEnableCaps Auto Mandatory

Float Property PipboyDetected Auto Conditional

Message Property _USSMessageEnabled Auto Mandatory
Message Property _USSMessageDisabled Auto Mandatory

Quest Property MQ102 Auto Mandatory
Holotape Property _USSConfigHolotape Auto Const Mandatory
Actor Property PlayerRef Auto Const Mandatory

Event OnTimer(int aiTimerID)
	; keep looping until the player leaves the vault, then give them the holotape
	if MQ102.IsObjectiveCompleted(1)
		PlayerRef.AddItem(_USSConfigHolotape, 1)
	else
		StartTimer(20)
	endif
EndEvent

Function updateTerminal(ObjectReference akTerminalRef)
	if akTerminalRef
		PipboyDetected = 0.0

		; Set the cap numbers in the cap adjustment interface
		if _USSCapFood.getValue() < 0
			akTerminalRef.AddTextReplacementData("CapFood", _USSMessageUnlimited)
		else
			akTerminalRef.AddTextReplacementData("CapFood", _USSCapFood)
		endif
	
		if _USSCapWater.getValue() < 0
			akTerminalRef.AddTextReplacementData("CapWater", _USSMessageUnlimited)
		else
			akTerminalRef.AddTextReplacementData("CapWater", _USSCapWater)
		endif

		if _USSCapScrap.getValue() < 0
			akTerminalRef.AddTextReplacementData("CapScrap", _USSMessageUnlimited)
		else
			akTerminalRef.AddTextReplacementData("CapScrap", _USSCapScrap)
		endif

		; Set the Enabled/Disabled messages in the uncapper toggle interface
		if _USSEnableFood.getValue() > 0
			akTerminalRef.AddTextReplacementData("ToggleFood", _USSMessageEnabled)
		else
			akTerminalRef.AddTextReplacementData("ToggleFood", _USSMessageDisabled)
		endif

		if _USSEnableWater.getValue() > 0
			akTerminalRef.AddTextReplacementData("ToggleWater", _USSMessageEnabled)
		else
			akTerminalRef.AddTextReplacementData("ToggleWater", _USSMessageDisabled)
		endif

		if _USSEnableScrap.getValue() > 0
			akTerminalRef.AddTextReplacementData("ToggleScrap", _USSMessageEnabled)
		else
			akTerminalRef.AddTextReplacementData("ToggleScrap", _USSMessageDisabled)
		endif

		if _USSEnableFertilizer.getValue() > 0
			akTerminalRef.AddTextReplacementData("ToggleFertilizer", _USSMessageEnabled)
		else
			akTerminalRef.AddTextReplacementData("ToggleFertilizer", _USSMessageDisabled)
		endif

		if _USSEnableCaps.getValue() > 0
			akTerminalRef.AddTextReplacementData("ToggleCaps", _USSMessageEnabled)
		else
			akTerminalRef.AddTextReplacementData("ToggleCaps", _USSMessageDisabled)
		endif

		; Set the numbers in the chance none adjustment interface
		akTerminalRef.AddTextReplacementData("CNFood", _USSFoodChanceNone)
		akTerminalRef.AddTextReplacementData("CNWater", _USSWaterChanceNone)
		akTerminalRef.AddTextReplacementData("CNScrap", _USSScrapChanceNone)

		; set the exponent in the advanced attack reducer interface
		akTerminalRef.AddTextReplacementData("ARexp", _USSAttackReducerExponent)
	else
		PipboyDetected = 1.0
	endif
EndFunction

Function modARExponent(float f)
	f = _USSAttackReducerExponent.getValue() + f
	_USSAttackReducerExponent.setValue(Math.Max(0,Math.Min(1.5,f)))
EndFunction

Function setARExponent(float f)
	_USSAttackReducerExponent.setValue(f)
EndFunction

Function enableAttackReducer(bool b)
	if b
		_USSEnableAttackReducer.setValue(1.0)
	else
		_USSEnableAttackReducer.setValue(0.0)
	endif
EndFunction

Function modFoodCap(float f)
	if (_USSCapFood.getValue() == -1.0)
		f += 1
	endif

	f = _USSCapFood.getValue() + f
	_USSCapFood.setValue(Math.Max(-1,f))
EndFunction

Function modWaterCap(float f)
	if (_USSCapWater.getValue() == -1.0)
		f += 1
	endif

	f = _USSCapWater.getValue() + f
	_USSCapWater.setValue(Math.Max(-1,f))
EndFunction

Function modScrapCap(float f)
	if (_USSCapScrap.getValue() == -1.0)
		f += 1
	endif

	f = _USSCapScrap.getValue() + f
	_USSCapScrap.setValue(Math.Max(-1,f))
EndFunction

Function modFoodCN(float f)
	f = _USSFoodChanceNone.getValue() + f
	_USSFoodChanceNone.setValue(Math.Max(0,Math.Min(100,f)))
EndFunction

Function modWaterCN(float f)
	f = _USSWaterChanceNone.getValue() + f
	_USSWaterChanceNone.setValue(Math.Max(0,Math.Min(100,f)))
EndFunction

Function modScrapCN(float f)
	f = _USSScrapChanceNone.getValue() + f
	_USSScrapChanceNone.setValue(Math.Max(0,Math.Min(100,f)))
EndFunction


