Scriptname USSResetScript extends Quest

Quest Property _USSQuest Auto Const Mandatory
Quest Property USSReset Auto Const Mandatory

Message Property _USSResetSuccess Auto Const Mandatory
Message Property _USSResetFail Auto Const Mandatory

; StartQuest/StopQuest as console commands have been known not to handle aliases properly.
Event OnQuestInit()
	ResetUSS()
EndEvent

Event OnTimer(int aiTimerID)
	if aiTimerID == 1
		ResetUSS()
	endif
EndEvent

Function ResetUSS()
	_USSQuest.Stop()
	Utility.wait(0.5) ; the waits probably aren't necessary, but won't hurt
	_USSQuest.Start()
	USSReset.Stop()
	Utility.wait(0.5)
	
	if _USSQuest.GetCurrentStageID() == 0
		_USSResetSuccess.Show()
	else
		_USSResetFail.Show()
	endif
EndFunction

