Scriptname USSResetScript extends Quest

Quest Property _USSQuest Auto Const Mandatory
Quest Property _USSHolotapeQuest Auto Const Mandatory
Quest Property _USSReset Auto Const Mandatory

Message Property _USSResetSuccess Auto Const Mandatory
Message Property _USSResetFail Auto Const Mandatory

; StartQuest/StopQuest as console commands have been known not to handle aliases properly.
Event OnQuestInit()
	ResetUSS()
EndEvent

Function ResetUSS()
	_USSQuest.Stop()
	_USSHolotapeQuest.Stop()
	Utility.wait(0.5) ; the waits probably aren't necessary, but won't hurt

	_USSQuest.Reset()
	_USSHolotapeQuest.Reset()
	Utility.wait(0.5)

	_USSQuest.Start()
	_USSHolotapeQuest.Start()
	Utility.wait(0.5)

	_USSReset.Stop()
	
	if _USSQuest.GetCurrentStageID() == 0
		_USSResetSuccess.Show()
	else
		_USSResetFail.Show()
	endif
EndFunction

