Scriptname idek:uss:USSHolotapeQuestScript extends Quest Conditional

Message Property _USSMessageUnlimited Auto Const Mandatory

GlobalVariable Property _USSAttackReducerExponent Auto Mandatory
GlobalVariable Property _USSEnableAttackReducer Auto Mandatory

GlobalVariable Property _USSCapFood Auto Mandatory
GlobalVariable Property _USSCapWater Auto Mandatory
GlobalVariable Property _USSCapScrap Auto Mandatory

GlobalVariable Property _USSEnableFood Auto Mandatory
GlobalVariable Property _USSEnableWater Auto Mandatory
GlobalVariable Property _USSEnableScrap Auto Mandatory
GlobalVariable Property _USSEnableFertilizer Auto Mandatory
GlobalVariable Property _USSEnableCaps Auto Mandatory

Float Property PipboyDetected Auto Conditional

Message Property _USSMessageEnabled Auto Mandatory
Message Property _USSMessageDisabled Auto Mandatory
Message Property _USSMessageVanilla Auto Mandatory
Message Property _USSMessage50 Auto Mandatory
Message Property _USSMessage3 Auto Mandatory

Quest Property MQ102 Auto Mandatory
Holotape Property _USSConfigHolotape Auto Const Mandatory
Actor Property PlayerRef Auto Const Mandatory

Event OnTimer(int aiTimerID)
	;for start-game stuff
	if (aiTimerID == 0)
		; keep looping until the player leaves the vault, then give them the holotape
		if MQ102.IsObjectiveCompleted(1)
			if (PlayerRef.GetItemCount(_USSConfigHolotape) == 0)
				PlayerRef.AddItem(_USSConfigHolotape, 1)
			endif
		else
			StartTimer(20, 0)
		endif
	endif
EndEvent

;/
Displays Vanilla if turned off, Unlimited if enabled, or e.g. 5000 if enabled and there's a user cap set.
Used in _USSConfigHolotapeChangeCapsFood etc and _USSConfigHolotapeToggleCaps
	CapFood 
	CapWater
	CapScrap
	CapFertilizer
	CapCaps
	
Displays enabled/disabled based on _USSEnableFood etc
Used in _USSConfigHolotapeToggleCaps
	ToggleFood - 
	ToggleWater
	ToggleScrap
	ToggleFertilizer
	ToggleCaps

Displays the attack reducer exponent
Used in _USSAttackReducerAdv
	ARexp
/;

Function updateTerminal(ObjectReference akTerminalRef)
	if akTerminalRef
		PipboyDetected = 0.0
		; Set the Enabled/Disabled messages in the uncapper toggle interface, and deal with the cap value display in various interfaces
		if _USSEnableFood.getValue() > 0
			akTerminalRef.AddTextReplacementData("ToggleFood", _USSMessageEnabled)
			
			if _USSCapFood.getValue() < 0
				akTerminalRef.AddTextReplacementData("CapFood", _USSMessageUnlimited)
			else
				akTerminalRef.AddTextReplacementData("CapFood", _USSCapFood)
			endif
		else
			akTerminalRef.AddTextReplacementData("ToggleFood", _USSMessageDisabled)
			akTerminalRef.AddTextReplacementData("CapFood", _USSMessageVanilla)
		endif

		if _USSEnableWater.getValue() > 0
			akTerminalRef.AddTextReplacementData("ToggleWater", _USSMessageEnabled)
			
			if _USSCapWater.getValue() < 0
				akTerminalRef.AddTextReplacementData("CapWater", _USSMessageUnlimited)
			else
				akTerminalRef.AddTextReplacementData("CapWater", _USSCapWater)
			endif
		else
			akTerminalRef.AddTextReplacementData("ToggleWater", _USSMessageDisabled)
			akTerminalRef.AddTextReplacementData("CapWater", _USSMessageVanilla)
		endif

		if _USSEnableScrap.getValue() > 0
			akTerminalRef.AddTextReplacementData("ToggleScrap", _USSMessageEnabled)
			
			if _USSCapScrap.getValue() < 0
				akTerminalRef.AddTextReplacementData("CapScrap", _USSMessageUnlimited)
			else
				akTerminalRef.AddTextReplacementData("CapScrap", _USSCapScrap)
			endif
		else
			akTerminalRef.AddTextReplacementData("ToggleScrap", _USSMessageDisabled)
			akTerminalRef.AddTextReplacementData("CapScrap", _USSMessageVanilla)
		endif

		if _USSEnableFertilizer.getValue() > 0
			akTerminalRef.AddTextReplacementData("ToggleFertilizer", _USSMessageEnabled)
			akTerminalRef.AddTextReplacementData("CapFertilizer", _USSMessageUnlimited)
		else
			akTerminalRef.AddTextReplacementData("ToggleFertilizer", _USSMessageDisabled)
			akTerminalRef.AddTextReplacementData("CapFertilizer", _USSMessage3)
		endif

		if _USSEnableCaps.getValue() > 0
			akTerminalRef.AddTextReplacementData("ToggleCaps", _USSMessageEnabled)
			akTerminalRef.AddTextReplacementData("CapCaps", _USSMessageUnlimited)
		else
			akTerminalRef.AddTextReplacementData("ToggleCaps", _USSMessageDisabled)
			akTerminalRef.AddTextReplacementData("CapCaps", _USSMessage50)
		endif

		; set the exponent in the advanced attack reducer interface
		akTerminalRef.AddTextReplacementData("ARexp", _USSAttackReducerExponent)
	else
		PipboyDetected = 1.0
	endif
EndFunction

Function modARExponent(float f)
	f = _USSAttackReducerExponent.getValue() + f
	_USSAttackReducerExponent.setValue(Math.Max(0.0,Math.Min(1.5,f)))
EndFunction

Function setARExponent(float f)
	_USSAttackReducerExponent.setValue(f)
EndFunction

Function enableAttackReducer(float f)
	_USSEnableAttackReducer.setValue(f)
EndFunction

Function modFoodCap(float f)
	if (_USSCapFood.getValue() == -1.0)
		f += 1
	endif

	f = _USSCapFood.getValue() + f
	_USSCapFood.setValue(Math.Max(-1.0,f))
EndFunction

Function modWaterCap(float f)
	if (_USSCapWater.getValue() == -1.0)
		f += 1
	endif

	f = _USSCapWater.getValue() + f
	_USSCapWater.setValue(Math.Max(-1.0,f))
EndFunction

Function modScrapCap(float f)
	if (_USSCapScrap.getValue() == -1.0)
		f += 1
	endif

	f = _USSCapScrap.getValue() + f
	_USSCapScrap.setValue(Math.Max(-1.0,f))
EndFunction