Scriptname idek:uss:USSResetScript extends Quest

WorkshopParentScript Property WorkshopParent Auto Const Mandatory

Quest Property _USSQuest Auto Const Mandatory
Quest Property _USSHolotapeQuest Auto Const Mandatory
Quest Property _USSReset Auto Const Mandatory

Message Property _USSResetSuccess Auto Const Mandatory
Message Property _USSResetFail Auto Const Mandatory

; StartQuest/StopQuest as console commands have been known not to handle aliases properly.
Event OnQuestInit()
	ResetUSS()
EndEvent

Function ResetUSS()
	_USSQuest.Stop()
	_USSHolotapeQuest.Stop()
	Utility.wait(0.5) ; the waits probably aren't necessary, but won't hurt

; One time, while testing, USS auto-reset precisely in the middle of an update, and didn't ever put DailyUpdateInProgress back to false
; This caused all settlements to stop working until I realized what was wrong and fixed it with a console command
; This might cause minor, temporary bugs on rare occasions, but that is preferable to breaking all settlements
WorkshopParent.DailyUpdateInProgress = false

; This causes things to break horribly, apparently resetting does -not- work with quest aliases
;	_USSQuest.Reset()
;	_USSHolotapeQuest.Reset()
;	Utility.wait(0.5)

	_USSQuest.Start()
	_USSHolotapeQuest.Start()
	Utility.wait(0.5)

	_USSReset.Stop()
	
	if _USSQuest.GetCurrentStageID() == 0
		_USSResetSuccess.Show()
	else
		_USSResetFail.Show()
	endif
EndFunction



